import zmq

# 設置 ZeroMQ 上下文
context = zmq.Context()
socket = context.socket(zmq.REQ)  # 設定為請求 (REQ) 模式
socket.connect("tcp://localhost:5555")  # 連接到伺服器

# 傳送請求並接收回應
for i in range(3):
    message = f"客戶端 {i}"
    print(f"傳送請求: {message}")
    socket.send_string(message)

    response = socket.recv_string()
    print(f"收到回應: {response}")
