import zmq

# 設置 ZeroMQ 上下文
context = zmq.Context()
socket = context.socket(zmq.REP)  # 設定為回應 (REP) 模式
socket.bind("tcp://*:5555")  # 監聽 5555 埠口

print("伺服器啟動，等待客戶端請求...")

while True:
    message = socket.recv_string()  # 接收訊息
    print(f"收到請求: {message}")
    
    response = f"伺服器回應: 你好, {message}!"
    socket.send_string(response)  # 回應客戶端
