from abc import ABC, abstractmethod

# 定義一個資料庫介面，規定大家都要有 connect 方法
class IDatabase(ABC):
    @abstractmethod
    def connect(self):
        pass

# 具體實作 MySQL 版資料庫
class MySQLDatabase(IDatabase):
    def connect(self):
        print("連線到 MySQL 資料庫！")

# 服務類別，同樣透過建構子注入依賴，這次接收的是介面型別
class UserService:
    def __init__(self, database: IDatabase):
        self.database = database  # 不管你是 MySQL、PostgreSQL，都行

    def login(self, username: str):
        self.database.connect()   # 登入時動態呼叫 connect
        print(f"使用者 {username} 登入成功！")

def main():
    db = MySQLDatabase()           # 換成任何符合 IDatabase 的實作都可以
    user_service = UserService(db) # 注入進去
    user_service.login("timmy")    # 呼叫登入

if __name__ == "__main__":
    main()

