#!/bin/sh

# 取得作業系統類型（例如 Darwin 表示 macOS）
system_type=$(uname -s)

# 如果是 macOS 系統，才執行以下區塊
if [ "$system_type" = "Darwin" ]; then

  # 這裡可以考慮加入使用 Homebrew 安裝 iTerm2 的指令（例如 brew install --cask iterm2）
  # 不過目前尚未實作

  # 檢查使用者家目錄下是否有 .iterm2 設定資料夾
  if [ -d "$HOME/.iterm2" ]; then
    echo "設定 iTerm2 偏好設定資料夾路徑"
    # 將 iTerm2 的偏好設定指向自訂的資料夾
    defaults write com.googlecode.iterm2 PrefsCustomFolder "$HOME/.iterm2"
  fi

fi
