import socket
from contextlib import closing

def find_free_port():
    # 建立一個暫時的 socket 來偵測可用的 port
    with closing(socket.socket(socket.AF_INET, socket.SOCK_STREAM)) as s:
        # bind 到 0 表示讓系統隨機分配一個可用的 port
        s.bind(('', 0))
        s.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
        # 回傳那個被分配到的 port 號
        return s.getsockname()[1]

# --- 在你的 Flask App 中可以這樣用 ---
if __name__ == '__main__':
    free_port = find_free_port()
    print(f"找到一個可用的 port: {free_port}")
    app.run(host='0.0.0.0', port=free_port)