-- 🔍 檢查目前 SQL Server 總連線數（包含系統連線）
SELECT COUNT(*) AS TotalConnections
FROM sys.dm_exec_sessions;

-- 🔍 只統計使用者的連線數（不包含 SQL Server 內部系統連線）
SELECT COUNT(*) AS UserConnections
FROM sys.dm_exec_sessions
WHERE is_user_process = 1;

-- 🔍 查詢目前 "活躍" 的連線數
SELECT COUNT(*) AS ActiveConnections
FROM sys.dm_exec_connections;

-- 🔍 查看每個 IP 連線的數量（用來分析哪個 IP 連接最多）
SELECT client_net_address, COUNT(*) AS ConnectionCount
FROM sys.dm_exec_connections
JOIN sys.dm_exec_sessions
ON sys.dm_exec_connections.session_id = sys.dm_exec_sessions.session_id
WHERE is_user_process = 1
GROUP BY client_net_address;

-- 🔍 用 sp_who2 查看詳細的連線資訊
-- 可以看到哪些帳號在連線、連線的主機、目前執行的查詢等
EXEC sp_who2;

-- 🔍 舊版 SQL Server 可用 sys.sysprocesses 查詢連線數
SELECT COUNT(*) AS TotalConnections
FROM sys.sysprocesses
WHERE dbid > 0;

-- ✅ 啟用進階選項（某些設定需要開啟這個才看得到）
EXEC sp_configure 'show advanced options', 1;
RECONFIGURE;

-- 🔍 檢查 SQL Server 允許的最大連線數
EXEC sp_configure 'user connections';

-- 🔍 查詢 SQL Server 等待統計（找出系統可能的瓶頸）
-- 如果某個 wait_type 的等待時間很長，代表這個部分可能是效能瓶頸
SELECT wait_type, waiting_tasks_count, wait_time_ms
FROM sys.dm_os_wait_stats
ORDER BY wait_time_ms DESC;
