import asyncio
import threading
import time

async def delayed_execution():
    # 在這裡執行延遲後的任務
    print("Delayed execution")

def blocking_sleep(seconds):
    time.sleep(seconds)

async def async_sleep(seconds):
    loop = asyncio.get_running_loop()
    await loop.run_in_executor(None, blocking_sleep, seconds)
    await delayed_execution()

async def main():
    # 呼叫非同步的 sleep 函數
    await async_sleep(1)

    # 繼續執行其他任務
    print("Continuing execution")

# 建立事件迴圈並執行主程式
asyncio.run(main())
