#!/usr/bin/env python3
# /// script
# requires-python = ">=3.13"
# dependencies = [
#     "skyfield",
# ]
# ///

# requires-python = ">=3.13"
# dependencies = [
#     "skyfield",
#     "jplephem",
#     "numpy",
# ]
import os

from lunar_calendar import LunarCalendar  # 假設類別存於 lunar_calendar.py

def main():
    # 輸出目錄
    output_dir = 'lunar_json'
    os.makedirs(output_dir, exist_ok=True)

    # 產生 1900~2100 年，每年一個 JSON 檔：<year>.json
    for year in range(1900, 2101):
        cal = LunarCalendar(year)
        filename = os.path.join(output_dir, f"{year}.json")
        cal.save_json(filename)

if __name__ == "__main__":
    main()

