import datetime

class LoggingMixin:
    """ 提供日誌功能的 Mixin 類別 """
    
    def log(self, message):
        """ 簡單的日誌紀錄方法 """
        timestamp = datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        print(f"[{timestamp}] {self.__class__.__name__}: {message}")

class User(LoggingMixin):
    """ 使用 LoggingMixin 的 User 類別 """
    
    def __init__(self, name):
        self.name = name
        self.log(f"User '{self.name}' 已建立")

    def update_name(self, new_name):
        self.log(f"名稱從 '{self.name}' 變更為 '{new_name}'")
        self.name = new_name

# 測試範例
if __name__ == "__main__":
    user = User("Alice")  # 會自動記錄 "User 'Alice' 已建立"
    user.update_name("Bob")  # 會記錄名稱變更的訊息
