from contextlib import contextmanager
import threading

lock = threading.Lock()

@contextmanager
def locked_resource():
    print("獲取鎖")
    lock.acquire()
    try:
        yield
    finally:
        lock.release()
        print("釋放鎖")

# 測試鎖機制
with locked_resource():
    print("執行臨界區程式")
