#!/bin/bash

# Delete the existing taiwan_ips ipset collection if it exists
ipset destroy taiwan_ips

# Create a new taiwan_ips ipset collection
ipset create taiwan_ips hash:net

# Download the Taiwan IP range file using wget (commented out)
wget https://github.com/Loyalsoldier/geoip/raw/release/text/tw.txt -O tw.txt

# Add IPv4 ranges to the ipset collection
while IFS= read -r line; do
    # Check if the line contains an IPv4 address
    if [[ "$line" =~ ^[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+ ]]; then
        ipset add taiwan_ips "$line"
    fi
done < tw.txt

# Delete the downloaded file (commented out)
# rm tw.txt

# View the contents of the taiwan_ips ipset collection
# ipset list taiwan_ips