import gc

class CircularReference:
    def __init__(self):
        self.ref = self  # 建立循環引用

# 建立一個有循環引用的物件
obj = CircularReference()

# 檢查物件是否被垃圾回收
print(f"物件存在於 gc 可達物件列表中: {gc.is_tracked(obj)}")

# 刪除變數（但仍有循環引用，GC 不會立即回收）
del obj

# 強制執行垃圾回收
gc.collect()

# 確認循環引用的物件是否被回收
print("強制執行垃圾回收後，未被釋放的物件數量:", gc.collect())
