import streamlit as st
import os

# 標題
st.title("文件內容查看器")

# 文件上傳
uploaded_file = st.file_uploader("請上傳文字或 Markdown 文件", type=["txt", "md"])

# 如果有文件被上傳
if uploaded_file is not None:
    # 讀取文件內容
    content = uploaded_file.read().decode("utf-8")

    # 儲存文件內容到暫存檔
    temp_file = f"temp_{uploaded_file.name}"
    with open(temp_file, "w", encoding="utf-8") as f:
        f.write(content)

    # 顯示文件內容
    st.subheader(f"文件內容 ({uploaded_file.name})")
    st.write(content)

    # 後續操作
    st.write("你可以在這裡對文件內容進行後續操作…")
    # 範例: 讀取暫存檔內容
    with open(temp_file, "r", encoding="utf-8") as f:
        temp_content = f.read()
    st.write(f"暫存檔內容: {temp_content}")

    # 刪除暫存檔
    os.remove(temp_file)