#!/usr/bin/env python
# -*- coding: utf-8 -*-


"""
a_simple_linear_regression_model.py: 透過使用 Python 的 sklearn 套件，訓練一個簡單的線性回歸模型，並使用該模型預測蘋果公司的股價變化。

Author: Timmy
Copyright: Copyright 2022, Timmy
License: MIT
Version: 1.0
"""

# 引入必要的模組
import numpy as np
from sklearn.linear_model import LinearRegression

# 載入蘋果公司的股價資料
apple = np.array([155, 156, 157])

# 計算資料筆數
n = len(apple)

# 建立線性迴歸模型
model = LinearRegression().fit(np.arange(n).reshape((n, 1)), apple)

# 預測第3、4天的股價
print(model.predict([[3], [4]]))
