# 檢查是否提供了目錄名稱參數
if ($args.Length -eq 0) {
    Write-Host "Usage: .\setup_project.ps1 <directory_name>"
    exit 1
}

# 將參數設定為 PROJECT_DIR 變數
$PROJECT_DIR = $args[0]

# 嘗試建立目錄
if (-not (Test-Path $PROJECT_DIR)) {
    New-Item -ItemType Directory -Path $PROJECT_DIR | Out-Null
} else {
    Write-Host "Failed: Unable to create directory '$PROJECT_DIR'. Exiting..."
    exit 1
}

# 切換到該目錄
Set-Location -Path $PROJECT_DIR

# 建立空的 index.html
New-Item -ItemType File -Name "index.html" | Out-Null

# 建立 src 目錄及其子目錄
New-Item -ItemType Directory -Name "src" | Out-Null
New-Item -ItemType Directory -Path "src\components" | Out-Null

# 建立 my-element.js 和 main.js 檔案
New-Item -ItemType File -Path "src\components\my-element.js" | Out-Null
New-Item -ItemType File -Path "src\main.js" | Out-Null

# 初始化 npm 專案
npm init -y

# 安裝 lit 為依賴
npm install lit --save

# 安裝 vite 和 serve 作為開發依賴
npm install vite --save-dev
npm install serve --save-dev

# 列出目錄結構（不包括 node_modules）
Write-Host "Directory structure:"
Get-ChildItem -Recurse -Directory | Where-Object { $_.Name -ne "node_modules" } | ForEach-Object { Write-Host $_.FullName }

# 暫停，讓使用者查看輸出
Pause
