import socket


class WakeOnLan:
    """
    WOL(Wake on LAN)
    """

    def __init__(self, macaddress):
        try:
            self.macaddress = self.validate_macaddress(macaddress)
            self.packet = self.create_magic_packet()
            self.broadcast_address = self.get_broadcast_ip()
            self.send_magic_packet()
        except Exception as e:
            print(e)

    def validate_macaddress(self, macaddress):
        import re

        macaddress_validate_pattern = "^(?:[0-9A-Fa-f]{2}[:-]){5}(?:[0-9A-Fa-f]{2})$"
        if re.match(macaddress_validate_pattern, macaddress):
            return macaddress
        else:
            raise ValueError("Incorrect Mac address")

    def create_magic_packet(self):
        sep = self.macaddress[2]
        macaddress_str = self.macaddress.replace(sep, "")
        return bytes.fromhex("F" * 12 + macaddress_str * 20)

    def get_broadcast_ip(self):
        import ipaddress

        local_ip = socket.gethostbyname(socket.gethostname())
        mask = "255.255.255.0"
        broadcast_address = ipaddress.IPv4Network(
            local_ip + "/" + mask, False
        ).broadcast_address
        return str(broadcast_address)

    def send_magic_packet(self):
        with socket.socket(socket.AF_INET, socket.SOCK_DGRAM) as sock:
            sock.setsockopt(socket.SOL_SOCKET, socket.SO_BROADCAST, 1)
            sock.sendto(self.packet, (self.broadcast_address, 7))
            # sock.sendto(self.packet, ("255.255.255.255", 7))


mac = "FC-AA-14-B4-4C-18"
foo = WakeOnLan(mac)
