import functools

@functools.lru_cache(maxsize=5)
def fibonacci(n):
    """計算費氏數列（具備快取功能）"""
    if n < 2:
        return n
    return fibonacci(n - 1) + fibonacci(n - 2)

print(fibonacci(10))  # 快速計算
print(fibonacci.cache_info())  # 顯示快取統計
