import functools

def my_decorator(func):
    @functools.wraps(func)
    def wrapper(*args, **kwargs):
        print(f"執行 {func.__name__} 函式")
        return func(*args, **kwargs)
    return wrapper

@my_decorator
def hello():
    """這是一個測試函式"""
    print("Hello, world!")

hello()
print(hello.__name__)  # 保持原函式名稱
print(hello.__doc__)   # 保持原函式說明
