# 引入需要用到的套件
import pandas as pd   # 用來處理資料，還能幫我們存成 CSV 檔
from pkg_resources import working_set  # 用來拿到所有已安裝的套件清單

# 步驟 1: 把所有已安裝的套件名稱和版本抓出來，直接變成 Pandas DataFrame
# 用列表生成式搭配 DataFrame，省去不必要的中間變數
df_packages = pd.DataFrame(
    [(pkg.key, pkg.version) for pkg in working_set], 
    columns=["Package", "Version"]
).sort_values(by="Package")

# 步驟 2: 把 DataFrame 存成 CSV 檔
csv_path = "installed_packages_sorted.csv"  # 設定 CSV 檔的名稱
df_packages.to_csv(csv_path, index=False)   # 存成 CSV，這裡不需要索引欄位

# 步驟 3: 提示使用者 CSV 檔案的位置
print(f"CSV 檔案已經存好了，在這裡喔: {csv_path}")

# 簡單說明：
# - 直接引入 `working_set`，少打幾個字，效能也會好一點。
# - 省去中間變數 `installed_packages`，更省記憶體，程式也更精簡。
# - `to_csv()` 設定 index=False，保證輸出結果跟原始版本一樣。
