#!/bin/bash

# 定義要檢查的目錄
TMP_DIR="/tmp"

# 查找所有以 ssh- 開頭的文件或目錄
for file in "$TMP_DIR"/ssh-*; do
    # 如果沒有匹配的文件，跳過
    if [ ! -e "$file" ]; then
        continue
    fi

    # 使用 lsof 檢查是否有進程使用該文件
    if lsof "$file" >/dev/null 2>&1; then
        echo "正在使用中，跳過: $file"
    else
        echo "未被使用，刪除: $file"
        rm -rf "$file"
    fi
done

echo "清理完成！"
