class SeverancePayCalculator:
    def __init__(self, salary, years_of_service, policy="new"):
        """
        初始化資遣費計算器
        :param salary: 每月工資 (int or float)
        :param years_of_service: 服務年數 (float)
        :param policy: "new" (新制) 或 "old" (舊制)
        """
        self.salary = salary
        self.years_of_service = years_of_service
        self.policy = policy.lower()
    
    def calculate(self):
        """ 計算資遣費 """
        if self.policy == "new":
            severance_pay = min(self.years_of_service * 0.5, 6) * self.salary
        elif self.policy == "old":
            severance_pay = min(self.years_of_service, 6) * self.salary
        else:
            raise ValueError("政策類型錯誤，請選擇 'new' 或 'old'")
        
        return round(severance_pay, 2)
    
    def __str__(self):
        return f"{self.policy.upper()} 制資遣費: {self.calculate()} 元"

# 測試範例
if __name__ == "__main__":
    salary = 100000  # 每月工資
    years_of_service = 8.5  # 服務年數

    new_policy_calculator = SeverancePayCalculator(salary, years_of_service, "new")
    # old_policy_calculator = SeverancePayCalculator(salary, years_of_service, "old")

    print(new_policy_calculator)
    # print(old_policy_calculator)

