import platform  
from funcy import decorator  

@decorator
def need_mac(call):
    """檢查系統是否為 macOS，若不是則拋出異常。"""
    if platform.system() != "Darwin":
        raise Exception("This functionality is only supported in macOS")
    return call()

@decorator
def need_linux(call):
    """檢查系統是否為 Linux，若不是則拋出異常。"""
    if platform.system() != "Linux":
        raise Exception("This functionality is only supported in Linux")
    return call()

@decorator
def need_windows(call):
    """檢查系統是否為 Windows，若不是則拋出異常。"""
    if platform.system() != "Windows":
        raise Exception("This functionality is only supported in Windows")
    return call()

@decorator
def need_unix(call):
    """檢查系統是否為 macOS 或 Linux，若不是則拋出異常。"""
    if platform.system() not in ["Darwin", "Linux"]:
        raise Exception("This functionality is only supported in macOS or Linux")
    return call()

@need_unix
def foo():
    """測試函式，僅在 macOS 或 Linux 上執行。"""
    print("Hello, world! (Running on macOS or Linux)")

@need_windows
def bar():
    """測試函式，僅在 Windows 上執行。"""
    print("Hello, world! (Running on Windows)")

if __name__ == "__main__":
    try:
        foo()  # 只有 macOS 和 Linux 可以執行
    except Exception as e:
        print(f"Error in foo(): {e}")

    try:
        bar()  # 只有 Windows 可以執行
    except Exception as e:
        print(f"Error in bar(): {e}")
