import platform  # 匯入 platform 模組

from funcy import decorator  # 匯入 funcy 模組中的 decorator 裝飾器

@decorator
def needmac(call):
    """檢查系統是否為 macOS，若不是則拋出異常。"""
    if platform.system() != "Darwin":
        raise Exception(
            "The system is not macOS. " "This functionality only supported in macOS"
        )

    return call()

@decorator
def needlinux(call):
    """檢查系統是否為 Linux，若不是則拋出異常。"""
    if platform.system() != "Linux":
        raise Exception(
            "The system is not Linux. " "This functionality only supported in Linux"
        )

    return call()

@needmac  # 裝飾器：需要 macOS 系統
@needlinux  # 裝飾器：需要 Linux 系統
def foo():
    """一個測試函式，若系統為 macOS 或 Linux，則印出 'Hello, world!'。"""
    print("Hello, world!")

foo()  # 呼叫函式
