#!/bin/bash

# 更新系統軟體庫
echo "更新系統軟體庫..."
sudo apt-get update -y

# 安裝必要套件
echo "安裝必要套件：apt-transport-https、ca-certificates 和 curl..."
DEBIAN_FRONTEND=noninteractive apt-get install -y -qq apt-transport-https ca-certificates curl >/dev/null

# 安裝 Docker
echo "下載並安裝 Docker..."
curl -sSL https://get.docker.com/ | CHANNEL=stable sh

# 驗證 Docker 是否安裝成功
if docker --version &> /dev/null
then
    echo "Docker 安裝成功！版本：$(docker --version)"
else
    echo "Docker 安裝失敗，請檢查網路或安裝腳本。"
fi

# 下載並安裝 Docker Compose
echo "下載並安裝 Docker Compose..."
curl -L "https://github.com/docker/compose/releases/download/v$(curl -Ls https://www.servercow.de/docker-compose/latest.php)/docker-compose-$(uname -s)-$(uname -m)" -o /usr/local/bin/docker-compose

# 賦予執行權限
chmod +x /usr/local/bin/docker-compose

# 驗證 Docker Compose 是否安裝成功
if docker-compose --version &> /dev/null
then
    echo "Docker Compose 安裝成功！版本：$(docker-compose --version)"
else
    echo "Docker Compose 安裝失敗，請檢查網路或安裝腳本。"
fi
