import shutil
import os

# 定義來源與目標
source_file = "example.txt"
destination_dir = "backup/"
destination_file = os.path.join(destination_dir, source_file)

# 確保目標目錄存在
os.makedirs(destination_dir, exist_ok=True)

# 複製檔案
shutil.copy(source_file, destination_file)
print(f"已複製 {source_file} 到 {destination_file}")

# 移動檔案
new_location = "moved_example.txt"
shutil.move(destination_file, new_location)
print(f"已移動 {destination_file} 到 {new_location}")

# 刪除目錄（小心使用）
shutil.rmtree(destination_dir)
print(f"已刪除目錄 {destination_dir}")
