def minguo_yyyymmdd_to_date(s: str) -> date:
    """
    TWSE Date 格式: 1150202 (民國115年02月02日)
    -> 西元: 2026-02-02
    """
    s = s.strip()
    if len(s) != 7 or not s.isdigit():
        raise ValueError(f"Invalid Date format: {s!r}")
    y = int(s[:3]) + 1911
    m = int(s[3:5])
    d = int(s[5:7])
    return date(y, m, d)
