import asyncio

async def run_command(*args):
    # 建立子行程
    process = await asyncio.create_subprocess_exec(
        *args,
        stdout=asyncio.subprocess.PIPE,
        stderr=asyncio.subprocess.PIPE)

    # 等待子行程完成
    stdout, stderr = await process.communicate()

    # 輸出結果
    if stdout:
        print(f'[stdout]\n{stdout.decode()}')
    if stderr:
        print(f'[stderr]\n{stderr.decode()}')

# 執行指令
# asyncio.run(run_command('ls', '-l'))
# asyncio.run(run_command('ping',  'www.google.com'))

# 執行指令
async def main():
    await asyncio.gather(
        run_command('ping', '-c', '4', 'www.google.com'),
        run_command('ls', '-l')
    )

asyncio.run(main())
