#!/bin/bash

# Check if a username was provided as an argument
if [ $# -ne 1 ]; then
    echo "Error: Please provide a username as an argument."
    exit 1
fi

# Get the username from the argument
username="$1"

# Prompt for the user's password
read -s -p "Enter password for $username: " password
echo

# Add the user and set the password
sudo adduser --home /home/$username --gecos "" --disabled-password $username
echo "$username:$password" | sudo chpasswd

# Add the user to the sudo group
sudo usermod -aG sudo $username

# Configure the sudoers file to allow the user to use sudo without a password
echo "$username ALL=(ALL:ALL) ALL" | sudo tee -a /etc/sudoers
echo "$username ALL=NOPASSWD: ALL" | sudo tee -a /etc/sudoers