import sqlite3
from uuid import uuid4

# 建立 SQLite 連線
conn = sqlite3.connect(":memory:")
cursor = conn.cursor()

# 建立帶有 UUID 的表
cursor.execute("""
CREATE TABLE users (
    id TEXT PRIMARY KEY,
    name TEXT
)
""")

# 插入一筆帶有 UUID 的資料
user_id = str(uuid4())
cursor.execute("INSERT INTO users (id, name) VALUES (?, ?)", (user_id, "Alice"))

# 查詢結果
cursor.execute("SELECT * FROM users")
print(cursor.fetchall())

conn.close()
