#!/bin/bash

# Define log file paths
AUTH_LOG="/var/log/auth.log"
BTMP_LOG="/var/log/btmp"
WTMP_LOG="/var/log/wtmp"
LASTLOG="/var/log/lastlog"
SYSLOG="/var/log/syslog"
MAIL_LOG="/var/log/mail.log"

# Clear specific log files
sudo truncate -s 0 $AUTH_LOG $BTMP_LOG $WTMP_LOG
sudo truncate -s 0 $LASTLOG

# Remove old compressed log files
sudo rm -f $AUTH_LOG.{1,2.gz,3.gz,4.gz}
sudo rm -f $SYSLOG.{1,2.gz,3.gz,4.gz}
sudo rm -f $MAIL_LOG.{1,2.gz,3.gz,4.gz}

# Reset lastlog and ensure permissions are correct
sudo cp /dev/null $LASTLOG
sudo chmod 644 $LASTLOG

# Reset failed login attempts
sudo faillog -r

# Clear remaining large files (optional)
sudo rm -f $BTMP_LOG.1

# Confirmation message
echo "Log files have been cleared and old logs removed."