# 設定當前使用的 GCP 專案

gcloud config set project <YOUR_PROJECT_ID>
gcloud config set project my-gcp-project-123456

# 查詢目前帳戶下的所有 Compute Engine 虛擬機（VM）

gcloud compute instances list

# 在 GCP 中建立一個靜態 IP

gcloud compute addresses create <STATIC_IP_NAME> --region <REGION>
gcloud compute addresses create my-static-ip --region us-central1

# 查看目前專案中的所有靜態 IP

gcloud compute addresses list

# 刪除 VM "<YOUR_VM_NAME>" 目前的外部 IP 配置

# ⚠️ 執行後 VM 會暫時失去外部連線，請確保有內部網路或 Cloud Shell 可用！

gcloud compute instances delete-access-config <YOUR_VM_NAME> \
 --zone <YOUR_VM_ZONE> \
 --access-config-name "External NAT"

gcloud compute instances delete-access-config my-vm-1 \
 --zone us-central1-a \
 --access-config-name "External NAT"

# 為 VM "<YOUR_VM_NAME>" 設定新的外部 IP

gcloud compute instances add-access-config <YOUR_VM_NAME> \
 --zone <YOUR_VM_ZONE> \
 --access-config-name "External NAT" \
 --address <STATIC_IP>

gcloud compute instances add-access-config my-vm-1 \
 --zone us-central1-a \
 --access-config-name "External NAT" \
 --address 35.234.56.78

# 查詢目前帳戶下的所有 Compute Engine 虛擬機（VM）

gcloud compute instances list

# 透過 SSH 連線至 VM

gcloud compute ssh <YOUR_USERNAME>@<YOUR_VM_NAME> --zone <YOUR_VM_ZONE>
gcloud compute ssh timmy@my-vm-1 --zone us-central1-a

# 更新 SSH 設定

gcloud compute config-ssh
