# 列出目前專案中的所有防火牆規則
gcloud compute firewall-rules list

# 查看特定防火牆規則的詳細資訊
gcloud compute firewall-rules describe <FIREWALL_RULE_NAME>

# 例如，查看名為 "allow-http" 的防火牆規則
gcloud compute firewall-rules describe allow-http

# 🔍 查找與特定 VM 標籤 (targetTags) 相關的防火牆規則
gcloud compute firewall-rules list --filter="targetTags:<VM_TAG>"

# 例如，查找與 "web-server" 這個標籤相關的防火牆規則
gcloud compute firewall-rules list --filter="targetTags=web-server"

# 📥 查詢所有「進站 (INGRESS)」的防火牆規則
gcloud compute firewall-rules list --filter="direction:INGRESS"

# 📤 查詢所有「出站 (EGRESS)」的防火牆規則
gcloud compute firewall-rules list --filter="direction:EGRESS"

# 🌐 查詢所有允許 TCP 80 (HTTP) 連線的防火牆規則
gcloud compute firewall-rules list --filter="allowed.tcp=80"

# 🔑 查詢所有允許 TCP 22 (SSH) 連線的防火牆規則
gcloud compute firewall-rules list --filter="allowed.tcp=22"
