import traceback

def faulty_function():
    return 1 / 0  # 這將觸發 ZeroDivisionError

try:
    faulty_function()
except Exception as e:
    error_message = f"Exception occurred: {str(e)}"
    stack_trace = traceback.format_exc()
    
    print(error_message)
    print("Stack Trace:")
    print(stack_trace)
    
    # 可將錯誤記錄到日誌檔案
    with open("error.log", "a") as log_file:
        log_file.write(error_message + "\n")
        log_file.write(stack_trace + "\n")
