USE [你的資料庫名稱];
SELECT 
    s.name AS SchemaName, 
    t.name AS TableName,
    p.rows AS RowCounts,
    SUM(a.total_pages) * 8 AS TotalSizeKB,
    SUM(a.used_pages) * 8 AS UsedSizeKB,
    (SUM(a.total_pages) - SUM(a.used_pages)) * 8 AS UnusedSizeKB
FROM 
    sys.tables t
INNER JOIN 
    sys.schemas s ON t.schema_id = s.schema_id
INNER JOIN 
    sys.partitions p ON t.object_id = p.object_id
INNER JOIN 
    sys.allocation_units a ON p.partition_id = a.container_id
WHERE 
    p.index_id IN (0,1)  -- 0:堆積表, 1:群集索引
GROUP BY 
    s.name, t.name, p.rows
ORDER BY 
    TotalSizeKB DESC;
