from flask import Flask
import multiprocessing

# 建立 Flask 應用程式
def create_app(port):
    app = Flask(__name__)

    @app.route('/')
    def home():
        return f"Hello from port {port}!"

    # 啟動 Flask 伺服器
    app.run(host='0.0.0.0', port=port, threaded=True)

if __name__ == '__main__':
    # 指定要監聽的埠號
    ports = [5000, 5001, 5002]
    
    # 建立多個 Process，分別執行 Flask 應用程式
    processes = []
    for port in ports:
        process = multiprocessing.Process(target=create_app, args=(port,))
        process.start()
        processes.append(process)

    # 確保主進程等待子進程執行
    for process in processes:
        process.join()
