def calculate_roi(investment_cost, investment_gain):
    """
    計算投資報酬率 (ROI) 的函數。

    :param investment_cost: 投資成本
    :param investment_gain: 投資收益
    :return: 投資報酬率 (ROI)
    """
    net_profit = investment_gain - investment_cost
    roi = (net_profit / investment_cost) * 100
    return roi

# 使用函數計算 ROI
investment_cost = 100  # 投資成本
investment_gain = 150  # 投資收益

# 輸出結果
roi = calculate_roi(investment_cost, investment_gain)
print(f"投資報酬率 (ROI): {roi}%")

