### 🐳 LXC 容器管理

# 查看所有容器
pct list

# 啟動容器
pct start <CT_ID>
pct start 101

# 進入容器
pct enter <CT_ID>
pct enter 102

# 停止容器
pct stop <CT_ID>

# 重啟容器
pct reboot <CT_ID>

# 刪除容器
pct destroy <CT_ID>

# 建立容器
pct create <CT_ID> <TEMPLATE_PATH> --hostname <NAME> --storage <STORAGE> --memory <MEM_MB> --cores <CPU_CORES> --net0 name=eth0,bridge=vmbr0,ip=<IP>/24,gw=<GATEWAY>

# 複製容器
pct clone <SOURCE_CT_ID> <NEW_CT_ID> --hostname <NEW_NAME>

# 從備份還原容器
pct restore <CT_ID> <BACKUP_FILE_PATH>

# 建立容器備份
vzdump <CT_ID> --mode snapshot --storage <STORAGE_NAME>

# 增加磁碟空間
pct resize <CT_ID> rootfs +<SIZE>

# 查看容器設定
pct config <CT_ID>

# 編輯容器設定（手動）
vi /etc/pve/lxc/<CT_ID>.conf


### 🖥️ VM 虛擬機管理
qm start <VM_ID>
qm shutdown <VM_ID>
qm stop <VM_ID>
qm restart <VM_ID>
qm create <VM_ID> --name <VM_NAME> --memory <MEMORY_SIZE> --cores <CPU_CORES> --net0 virtio,bridge=vmbr0
qm del <VM_ID>
qm log <VM_ID>

### 🔗 Cluster & Corosync
pvecm expected <數字>
pvecm status
corosync-cfgtool -s
vi /etc/pve/corosync.conf
systemctl restart corosync
systemctl restart pve-cluster

### 📦 Storage 管理
pvesm status
pvesm alloc <STORAGE_NAME> <SIZE>
pvesm remove <STORAGE_NAME>

### 👤 使用者 & 權限
pveum user list
pveum user add <USERNAME>@<REALM> --password <PASSWORD>
pveum user del <USERNAME>@<REALM>
pveum aclmod /vms/<VM_ID> --add <USERNAME>@<REALM> --role <ROLE>

### 🌐 網路設定
ip a
vi /etc/network/interfaces
systemctl restart networking

### 💾 備份 & 還原
vzdump <VM_ID> --storage <STORAGE_NAME> --mode snapshot
vzdump --restore <BACKUP_FILE> <NEW_VM_ID>

### ⚙️ 系統更新 & 日誌
apt update && apt dist-upgrade
journalctl -xe
reboot

### 🔀 Cluster 節點管理
pvecm delnode <NODE_NAME>
pvecm addnode <NODE_NAME>
pvecm add <NODE_IP>
pvecm nodes
pmxcfs -l
