#!/bin/bash
# Proxmox VE 常用指令備忘錄（適用版本：7.x/8.x）
# 分類：
#  - LXC 容器管理
#  - VM 虛擬機管理
#  - Cluster 與 Corosync
#  - 儲存空間管理
#  - 使用者與權限
#  - 網路設定
#  - 備份與還原
#  - 系統更新與日誌
#  - Cluster 節點管理


# === LXC 容器管理 ===

# 查看所有容器
pct list

# 啟動容器
pct start 101  # 容器 ID: 101

# 進入容器
pct enter 102  # 容器 ID: 102

# 停止容器
pct stop 101

# 重啟容器
pct reboot 101

# 刪除容器（不可逆，小心操作）
pct destroy 101

# 建立新容器
pct create 101 /var/lib/vz/template/cache/debian-11-standard_11.6-1_amd64.tar.zst \
  --hostname web01 \                # 主機名稱
  --storage local-lvm \             # 儲存區名稱
  --memory 512 \                    # 記憶體大小（MB）
  --cores 2 \                       # CPU 核心數
  --net0 name=eth0,bridge=vmbr0,ip=192.168.1.100/24,gw=192.168.1.1
  # IP 和閘道請視環境設定

# 複製容器
pct clone 101 102 --hostname web02  # 從 101 複製為 102，主機名改為 web02

# 從備份還原容器
pct restore 103 /var/lib/vz/dump/vzdump-lxc-101-2024_04_07-10_00_00.tar.zst
pct restore 103 /var/lib/vz/dump/vzdump-lxc-101-2024_04_07-10_00_00.tar.zst --storage local-lvm

# 建立容器備份
vzdump 101 --mode snapshot --storage local

# 增加容器磁碟容量
pct resize 101 rootfs 5G  # 增加 5G 空間

# 查看容器設定
pct config 101

# 手動編輯容器設定
vi /etc/pve/lxc/101.conf


# === VM 虛擬機管理 ===

qm start 200
qm shutdown 200
qm stop 200
qm restart 200

# 設定 VM CPU 類型（例如改善相容性或效能）
qm set 100 --cpu cputype=kvm64


# 建立 VM
qm create 201 --name webvm01 --memory 2048 --cores 2 --net0 virtio,bridge=vmbr0

qm del 200
qm log 200


# === Cluster 與 Corosync ===

pvecm expected 1              # 設定預期節點數量
pvecm status                  # 查看叢集狀態
corosync-cfgtool -s           # 檢查 corosync 設定
vi /etc/pve/corosync.conf     # 編輯 corosync 設定
systemctl restart corosync
systemctl restart pve-cluster


# === 儲存空間管理 ===

pvesm status
pvesm alloc local-lvm 10G     # 建立空間
pvesm remove local            # 移除儲存定義（會影響使用該儲存的 VM/LXC）


# === 使用者與權限 ===

pveum user list
pveum user add alice@pve --password 'StrongPass123'
pveum user del alice@pve
pveum aclmod /vms/200 --add alice@pve --role PVEVMAdmin


# === 網路設定 ===

ip a
vi /etc/network/interfaces
systemctl restart networking


# === 備份與還原 ===

# 備份 VM
vzdump 200 --storage local --mode snapshot

# 還原 VM
vzdump --restore /var/lib/vz/dump/vzdump-qemu-200-2024_04_07-10_00_00.vma.zst 201


# === 系統更新與日誌 ===

apt update && apt dist-upgrade
journalctl -xe
reboot


# === Cluster 節點管理 ===

pvecm delnode node2
pvecm addnode node2
pvecm add 192.168.1.101        # 加入新節點 IP
pvecm nodes
pmxcfs -l
