### 🐳 LXC 容器管理

# 查看所有容器
pct list

# 啟動容器
pct start 101 # CT_ID=101

# 進入容器
pct enter 102 # CT_ID=102

# 停止容器
pct stop 101 # CT_ID=101

# 重啟容器
pct reboot 101 # CT_ID=101

# 刪除容器
pct destroy 101 # CT_ID=101

# 建立容器
pct create 101 /var/lib/vz/template/cache/debian-11-standard_11.6-1_amd64.tar.zst
--hostname web01    # NAME=web01
--storage local-lvm # STORAGE=local-lvm
--memory 512        # MEM_MB=512
--cores 2           # CPU_CORES=2
--net0 name=eth0,bridge=vmbr0,ip=192.168.1.100/24,gw=192.168.1.1
# IP=192.168.1.100, GATEWAY=192.168.1.1

# 複製容器
pct clone 101 102 --hostname web02 # SOURCE_CT_ID=101, NEW_CT_ID=102, NEW_NAME=web02

# 從備份還原容器
pct restore 103 /var/lib/vz/dump/vzdump-lxc-101-2024_04_07-10_00_00.tar.zst
pct restore 103 /var/lib/vz/dump/vzdump-lxc-101-2024_04_07-10_00_00.tar.zst --storage local-lvm
# CT_ID=103, BACKUP_FILE_PATH=..., STORAGE=local-lvm

# 建立容器備份
vzdump 101 --mode snapshot --storage local # CT_ID=101, STORAGE_NAME=local

# 增加磁碟空間
pct resize 101 rootfs 5G # CT_ID=101, SIZE=5G

# 查看容器設定
pct config 101 # CT_ID=101

# 編輯容器設定（手動）
vi /etc/pve/lxc/101.conf # CT_ID=101

### 🖥️ VM 虛擬機管理

qm start 200 # VM_ID=200
qm shutdown 200
qm stop 200
qm restart 200

qm create 201 --name webvm01 --memory 2048 --cores 2 --net0 virtio,bridge=vmbr0
# VM_ID=201, VM_NAME=webvm01, MEMORY_SIZE=2048, CPU_CORES=2

qm del 200
qm log 200

### 🔗 Cluster & Corosync

pvecm expected 1 # 改變預期節點數
pvecm status
corosync-cfgtool -s
vi /etc/pve/corosync.conf
systemctl restart corosync
systemctl restart pve-cluster

### 📦 Storage 管理

pvesm status
pvesm alloc local-lvm 10G # STORAGE_NAME=local-lvm, SIZE=10G
pvesm remove local

### 👤 使用者 & 權限

pveum user list
pveum user add alice@pve --password 'StrongPass123'
pveum user del alice@pve
pveum aclmod /vms/200 --add alice@pve --role PVEVMAdmin

### 🌐 網路設定

ip a
vi /etc/network/interfaces
systemctl restart networking

### 💾 備份 & 還原

vzdump 200 --storage local --mode snapshot # VM_ID=200, STORAGE_NAME=local

# 備份還原
vzdump --restore /var/lib/vz/dump/vzdump-qemu-200-2024_04_07-10_00_00.vma.zst 201
# BACKUP_FILE=..., NEW_VM_ID=201

### ⚙️ 系統更新 & 日誌

apt update && apt dist-upgrade
journalctl -xe
reboot

### 🔀 Cluster 節點管理

pvecm delnode node2 # NODE_NAME=node2
pvecm addnode node2
pvecm add 192.168.1.101 # NODE_IP=192.168.1.101
pvecm nodes
pmxcfs -l
