import sys

from loguru import logger  # 引入logger套件

logger.remove()  # 移除現有的logger設定
logger.add(sys.stderr, level="INFO")  # 將logger設定加入到stderr中，並設定level為"INFO"
# logger.add(sys.stderr, level="WARNING")
# logger.add(sys.stderr, level="ERROR")
# logger.add(sys.stderr, level="TRACE")

logger.add("log.txt", level="INFO")  # 將logger設定加入到指定的檔案中，並設定level為"INFO"


def only_debug_filter(record):
    return record["level"].name == "DEBUG"


logger.add("debug.txt", filter=only_debug_filter, level="DEBUG")

logger.debug("Debug message")
logger.info("Info message")
logger.warning("Warning message")
logger.trace("Hello, World!")
logger.success("Success message")


# 使用 logger.error() 函式來顯示 error 等級的 log
logger.error("Error message")  # ERROR

# 在日誌中記錄"Critical message"，日誌級別為"CRITICAL"
logger.critical("Hello, World!")  # CRITICAL
logger.critical("Critical message")

# 在日誌中記錄"We got a BIG problem"，並將文字"BIG"標記為紅色，日誌級別為"WARNING"
logger.opt(colors=True).warning("We got a <red>BIG</red> problem")


# 在日誌中記錄"Per message colors"，並將文字"colors"標記為藍色，日誌級別為"INFO"
logger.opt(colors=True).info("Per message <blue>colors</blue>")

# 在日誌中記錄"Display values from the record (eg. {record[thread]})"，
# 並顯示日誌記錄中的某些值，例如"thread"鍵所對應的值，日誌級別為"INFO"
logger.opt(record=True).info("Display values from the record (eg. {record[thread]})")


# By the way, "opt()" serves many usages
logger.opt(exception=True).info(
    "Error stacktrace added to the log message (tuple accepted too)"
)

try:
    raise ValueError("This is a test error")
except ValueError as e:
    logger.exception(e)

logger.opt(raw=True).info("Bypass sink formatting\n")

# logger.opt(depth=1).info("Use parent stack context (useful within wrapped functions)")
logger.opt(capture=False).info(
    "Keyword arguments not added to {dest} dict", dest="extra"
)

# 建立一個函數，用來計算給定數字的除法
def divide(num1, num2):
    return num1 / num2


# 呼叫函數並輸出結果
result = divide(10, 5)
print(result)

# 處理除以0的例外情況
try:
    result = divide(10, 0)
except ZeroDivisionError:
    print("除數不能為0")
    logger.exception("除數不能為0")  # 記錄錯誤訊息


# 結束程式
print("程式結束")


# https://loguru.readthedocs.io/en/stable/api/logger.html
