import random
import string


class PasswordGenerator:
    def __init__(self, type, length=12):

        self.length = length
        self.type = type

    def generate_password(self):
        if self.type == "easy":
            # 存儲大小寫英文字母和數字，避免使用可能有歧義的字符
            characters = (
                string.ascii_uppercase.replace("O", "")
                + string.ascii_lowercase.replace("l", "")
                + string.digits.replace("0", "").replace("1", "")
            )
            # 隨機選擇 self.length 個字符
            password = "".join(random.choice(characters) for i in range(self.length))
        elif self.type == "hard":
            # 存儲大小寫英文字母和罕見的字元
            characters = string.ascii_letters + string.punctuation
            # 隨機選擇 self.length 個字符
            password = "".join(random.choice(characters) for i in range(self.length))
        return password


# 建立一個長度為 12 的密碼產生器物件，用來產生 "Easy to read" 的密碼
generator = PasswordGenerator("easy")

# 建立一個長度為 10 的密碼產生器物件，用來產生 "Easy to read" 的密碼
# generator = PasswordGenerator("easy", 10)


# 產生 10 個隨機密碼
for i in range(10):
    print(generator.generate_password())
