import jwt
import datetime

# 假設的使用者資訊
user = {
  'id': 123,
  'username': 'exampleUser'
}

# 生成 JWT
secret = 'your_secret_key'
token = jwt.encode({'user': user, 'exp': datetime.datetime.utcnow() + datetime.timedelta(minutes=30)}, secret, algorithm='HS256') # 使用自訂的密鑰

print('生成的 JWT：', token)

# 驗證 JWT
try:
    decoded = jwt.decode(token, secret, algorithms=['HS256']) # 使用相同的密鑰進行驗證
    print('驗證成功，解碼後的內容：', decoded)
except jwt.ExpiredSignatureError:
    print('Token已過期')
except jwt.InvalidTokenError:
    print('無效的Token')

