import streamlit as st
import pandas as pd

def main():
    # 初始化 session_state
    if "data" not in st.session_state:
        st.session_state.data = pd.DataFrame({
            "ID": [1, 2, 3],
            "Name": ["Alice", "Bob", "Charlie"],
            "Age": [25, 30, 35],
            "OtherField": ["Edit me", "Edit me too", "Also editable"]
        })
    if "edited_data" not in st.session_state:
        st.session_state.edited_data = None
    if "is_submitted" not in st.session_state:
        st.session_state.is_submitted = False

    # 介面標題與說明
    st.title("可編輯的 DataFrame 範例")
    st.header("請編輯表格內容，並點擊 '更新資料' 以儲存變更。")

    # 編輯 DataFrame
    edited_df = st.data_editor(
        st.session_state.data,
        num_rows="fixed",
        key="editable_table",
        use_container_width=True,
        column_config={
            "ID": st.column_config.NumberColumn("ID", disabled=True),  # 禁止編輯 ID
            "OtherField": st.column_config.TextColumn("OtherField")  # 允許編輯 OtherField
        },
    )

    # 按鈕：儲存編輯後的資料
    if st.button("更新資料"):
        st.session_state.edited_data = edited_df
        st.session_state.is_submitted = True
        st.success("變更已儲存！")

    # 更新 session_state 的資料
    if st.session_state.edited_data is not None and st.session_state.is_submitted:
        st.session_state.data = st.session_state.edited_data
        st.success("資料已更新！")
        st.session_state.edited_data = None
        st.session_state.is_submitted = False

    # 顯示目前資料
    st.subheader("目前資料：")
    st.dataframe(st.session_state.data)

if __name__ == "__main__":
    main()

