# 顯示網卡目前連線狀態
# 重點查看 Speed / Duplex / Auto-negotiation / Link detected
ethtool eth0

# 顯示網卡驅動與韌體資訊
# 常用於確認是否為 virtio / ixgbe / e1000 等驅動
ethtool -i eth0

# 顯示網卡 offload 功能狀態
# 常見項目：tso / gso / gro / checksum offload
ethtool -k eth0

# 關閉 TCP segmentation 與 generic offload
# 常用於封包分析、VPN、特定防火牆或疑難排解場景
ethtool -K eth0 tso off gso off gro off

# 一次執行三個常用檢查指令
# 快速確認連線狀態、驅動版本與 offload 設定
ethtool eth0 && ethtool -i eth0 && ethtool -k eth0

# 顯示 RX / TX ring buffer 目前值與最大支援值
# 高流量或封包遺失問題時必查
ethtool -g eth0

# 設定 RX / TX ring buffer 大小
# 提升高流量環境的吞吐量，不能超過 driver 支援上限
ethtool -G eth0 rx 4096 tx 4096

# 啟用常見的效能型 offload 功能
# 適合正常運作的高吞吐情境（非封包分析）
ethtool -K eth0 gro on gso on tso on

# 設定 combined channel 數量
# 常用於多核心系統、VM 或 container host
# 數量通常不超過 CPU core 數
ethtool -L eth0 combined 4
