# 定義 Person 類別
class Person:
    # 定義建構子
    def __init__(self, name):
        # 設定人的名字
        self.name = name

    # 定義取得人的名字的方法
    def get_name(self):
        """取得人的名字"""

        # 回傳人的名字
        return self.name


# 定義 Employee 類別，繼承自 Person 類別
class Employee(Person):
    # 定義建構子
    def __init__(self, name, staff_id):
        # 呼叫父類別的建構子，設定人的名字
        Person.__init__(self, name)
        # 設定員工的員工編號
        self.staff_id = staff_id

    # 定義取得完整員工識別資料的方法
    def get_full_id(self):
        """取得完整員工識別資料"""
        # 取得人的名字
        name = self.get_name()
        # 將人的名字與員工編號合併成員工的完整識別資料
        full_id = name + ", " + self.staff_id

        # 回傳員工的完整識別資料
        return full_id


# 建立一個 Person 物件，並設定名字為 Bill
person = Person("Bill")

# 建立一個 Employee 物件，並設定名字為 John、員工編號為 A23
employee = Employee("John", "A23")

# 測試 person 物件的 get_name 方法，應該回傳 Bill
assert person.get_name() == "Bill"

# 測試 employee 物件的 get_name 方法，應該回傳 John
assert employee.get_name() == "John"

# 測試 employee 物件的 get_full_id 方法，應該回傳 John, A23
assert employee.get_full_id() == "John, A23"

# 測試 Employee 類別是否為 employee 物件的父類別
assert isinstance(employee, Employee)

# 測試 Person 類別是否為 employee 物件的父類別
assert not isinstance(person, Employee)

# 測試 Person 類別是否為 person 物件的父類別
assert isinstance(person, Person)

# 測試 Person 類別是否為 employee 物件的父類別
assert isinstance(employee, Person)

# 測試 Employee 類別是否為 Person 類別的子類別
assert issubclass(Employee, Person)

# 測試 Person 類別是否為 Employee 類別的子類別
assert not issubclass(Person, Employee)
