import hashlib

def file_checksum(file_path):
    sha256 = hashlib.sha256()
    with open(file_path, "rb") as f:
        for chunk in iter(lambda: f.read(4096), b""):
            sha256.update(chunk)
    return sha256.hexdigest()

file_path = "example.txt"
print(f"{file_path} 的 SHA-256 雜湊值: {file_checksum(file_path)}")
