import bcrypt


def encode_password(password: str) -> str:
    salt = bcrypt.gensalt()
    hashed = bcrypt.hashpw(password.encode(), salt)
    return hashed.decode()


def check_password(password: str, hashed: str) -> bool:
    return bcrypt.checkpw(password.encode(), hashed.encode())


if __name__ == "__main__":
    password = "super secret password"
    hashed = encode_password(password)
    print(hashed)
    print(check_password(password, hashed))
