import sqlite3


# 初始化資料庫及表格
def initialize_db(db_name="database.db", table_name="entries"):
    conn = sqlite3.connect(db_name)
    cursor = conn.cursor()
    cursor.execute(
        f"""
        CREATE TABLE IF NOT EXISTS {table_name} (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            title TEXT NOT NULL,
            link TEXT NOT NULL UNIQUE,
            published TEXT,
            description TEXT
        )
    """
    )
    conn.commit()
    conn.close()
    print(f"資料庫 `{db_name}` 和表格 `{table_name}` 初始化完成。")


# 插入新資料
def insert_entry(entry, db_name="database.db", table_name="entries"):
    try:
        conn = sqlite3.connect(db_name)
        cursor = conn.cursor()
        cursor.execute(
            f"""
            INSERT INTO {table_name} (title, link, published, description)
            VALUES (?, ?, ?, ?)
        """,
            (
                entry["title"],
                entry["link"],
                entry.get("published", None),
                entry.get("description", None),
            ),
        )
        conn.commit()
        print(f"成功插入新條目: {entry['title']}")
    except sqlite3.IntegrityError:
        print(f"條目已存在，跳過插入: {entry['link']}")
    finally:
        conn.close()


# 測試範例
if __name__ == "__main__":
    # 初始化資料庫
    initialize_db(db_name="example.db", table_name="feed_entries")

    # 測試插入資料
    test_entry = {
        "title": "範例標題",
        "link": "https://example.com/item1",
        "published": "2025-01-08",
        "description": "這是一個範例描述。",
    }
    insert_entry(test_entry, db_name="example.db", table_name="feed_entries")
