#!/usr/bin/env python
# -*- coding: utf-8 -*-


"""
factory.py: 工廠方法模式的範例程式

Author: Timmy
Copyright: Copyright 2022, Timmy
授權方式: MIT
版本: 1.0
"""


class GreekLocalizer:
    def __init__(self):  # 建構子，在建立物件時會自動執行
        self.translations = {"dog": "σκύλος", "cat": "γάτα"}  # 定義字典 translations

    def localize(self, msg):  # 定義 localize 方法
        return self.translations.get(msg, msg)  # 傳回 translations 字典的對應轉換，若無則傳回原本的 msg


class GreekLocalizer:
    def __init__(self):  # 建構子，在建立物件時會自動執行
        self.translations = {"dog": "σκύλος", "cat": "γάτα"}  # 定義字典 translations

    def localize(self, msg):  # 定義 localize 方法
        return self.translations.get(msg, msg)  # 傳回 translations 字典的對應轉換，若無則傳回原本的 msg


class EnglishLocalizer:  # 定義 EnglishLocalizer 類別
    def localize(self, msg):  # 定義 localize 方法
        return msg  # 傳回原本的 msg，即不進行轉換


class ChineseLocalizer:
    def __init__(self):  # 建構子，在建立物件時會自動執行
        self.translations = {"dog": "狗", "cat": "貓"}  # 定義字典 translations

    def localize(self, msg):  # 定義 localize 方法
        return self.translations.get(msg, msg)  # 傳回 translations 字典的對應轉換，若無則傳回原本的 msg


def get_localizer(language="English"):  # 定義 get_localizer 函式
    """Factory"""

    # 定義字典 localizers
    localizers = {
        "English": EnglishLocalizer,  # 英文的 Localizer
        "Greek": GreekLocalizer,  # 希臘文的 Localizer
        "Chinese": ChineseLocalizer,  # 中文的 Localizer
    }

    # 傳回對應語言的 Localizer 物件
    return localizers[language]()


def main():

    e, g, ch = (
        get_localizer(language="English"),
        get_localizer(language="Greek"),
        get_localizer(language="Chinese"),
    )

    # 將字串 "dog parrot cat bear" 依照空白斷開，並按順序逐一取出
    for msg in "dog parrot cat bear".split():
        # 印出英文、希臘文、中文的 Localizer 對於該字串
        print(e.localize(msg), g.localize(msg), ch.localize(msg))


if __name__ == "__main__":
    main()
