import streamlit as st
import streamlit.components.v1 as components

st.title("使用 Lit Web Component (無 CDN)")

lit_component = """
<script type="module">
    class MyLitComponent extends HTMLElement {
        constructor() {
            super();
            this.attachShadow({ mode: 'open' });
            this.shadowRoot.innerHTML = `
                <style>
                    :host {
                        display: block;
                        text-align: center;
                        padding: 10px;
                        border: 2px solid #007bff;
                        border-radius: 8px;
                        background-color: #f8f9fa;
                        width: 100%;
                        max-width: 400px;
                        margin: auto;
                    }
                    h2 {
                        color: #007bff;
                    }
                    button {
                        padding: 10px 20px;
                        font-size: 16px;
                        cursor: pointer;
                        background-color: #007bff;
                        color: white;
                        border: none;
                        border-radius: 4px;
                        margin-top: 10px;
                    }
                </style>
                <h2>這是一個 Lit Web Component</h2>
                <p>使用 Lit 來建立的自訂元件</p>
                <button id="btn">點擊我</button>
            `;
            this.shadowRoot.getElementById("btn").addEventListener("click", () => {
                alert("你點擊了 Lit 按鈕！");
            });
        }
    }

    customElements.define('my-lit-component', MyLitComponent);
</script>

<my-lit-component></my-lit-component>
"""

components.html(lit_component, height=250)
